package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.Region;
import com.bxm.lovelink.common.dal.entity.vo.region.RegionVo;
import com.bxm.lovelink.common.dal.mapper.RegionMapper;
import com.bxm.lovelink.common.dal.mapping.RegionMapping;
import com.bxm.lovelink.common.dal.service.IRegionService;
import com.bxm.warcar.utils.KeyBuilder;
import com.bxm.warcar.xcache.Fetcher;
import com.bxm.warcar.xcache.Target;
import com.bxm.warcar.xcache.TargetFactory;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * <p>
 * 区域表 服务实现类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-17
 */
@Service
public class RegionServiceImpl extends ServiceImpl<RegionMapper, Region> implements IRegionService {

    private final Fetcher fetcher;

    public RegionServiceImpl(Fetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Override
    public List<RegionVo> listByRootChildren() {
        return listByRoot().getChildren();
    }

    @Override
    public List<RegionVo> getByParentCode(Integer parentCode) {
        if(parentCode == null){
            parentCode = Constants.PARENT_CODE;
        }
        List<Region> list = list(new LambdaQueryWrapper<Region>()
                .eq(Region::getParentCode, parentCode));
        return RegionMapping.INSTANCE.doToVo(list);
    }

    @Override
    public RegionVo listByRoot() {
        Map<Integer, List<Region>> regions = list().stream().collect(Collectors.groupingBy(Region::getParentCode, Collectors.toList()));
        RegionVo root = new RegionVo().setCode( Constants.PARENT_CODE);
        buildTree(root, regions);
        return root;
    }

    @Override
    public Map<Integer, String> queryByCodes(List<Integer> codes) {
        Map<Integer, String> result = new HashMap<>();
        if (CollectionUtils.isEmpty(codes)) {
            return result;
        }
        codes.removeIf(Objects::isNull);
        if (CollectionUtils.isEmpty(codes)) {
            return result;
        }
        Set<Integer> newCodes = new HashSet<>(codes);
        for (Integer code : codes) {
            newCodes.add(code / 10000 * 10000);
            newCodes.add(code / 100 * 100);
        }
        return listByIds(newCodes).stream().collect(Collectors.toMap(Region::getCode, Region::getName));
    }

    @Override
    public <U> Map<Integer, U> fetchAll(Function<Region, U> valueMapper) {
        Target<Region> target = new TargetFactory<Region>()
                .keyGenerator(() -> KeyBuilder.build("lovelink", "region", "all"))
                .cls(Region.class)
                .expireTimeInSecond(30 * 60)
                .listDataExtractor(this::list)
                .build();
        List<Region> regions = fetcher.fetchToList(target);
        if (CollectionUtils.isEmpty(regions)) {
            return Collections.emptyMap();
        }
        return regions.stream().collect(Collectors.toMap(Region::getCode, valueMapper));
    }

    private void buildTree(RegionVo result, Map<Integer, List<Region>> regionMap) {
        List<Region> regions = regionMap.get(result.getCode());
        if (CollectionUtils.isEmpty(regions)) {
            return;
        }
        List<RegionVo> regionVos = RegionMapping.INSTANCE.doToVo(regions);
        result.setChildren(regionVos);
        for (RegionVo regionVo : regionVos) {
            buildTree(regionVo, regionMap);
        }
    }


}
