package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageResult;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/17
 */
@Service
public class SensitiveServiceImpl implements ISensitiveService, ApplicationListener<ApplicationReadyEvent> {

    private final List<SensitiveTextIntegration> textList = new ArrayList<>();
    private final List<SensitiveImageIntegration> imageList = new ArrayList<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        textList.addAll(applicationContext.getBeansOfType(SensitiveTextIntegration.class).values());
        imageList.addAll(applicationContext.getBeansOfType(SensitiveImageIntegration.class).values());
    }

    @Override
    public SensitiveTextResult checkText(String text) {
        if (StringUtils.isBlank(text)) {
            return new SensitiveTextResult();
        }
        if (textList.isEmpty()) {
            throw new BusinessException("不支持敏感词检测");
        }
        return textList.get(0).checkText(text);
    }

    @Override
    public SensitiveImageResult checkImage(Integer type, String imageUrl) {
        if (StringUtils.isBlank(imageUrl)) {
            return new SensitiveImageResult();
        }
        if (imageList.isEmpty()) {
            throw new BusinessException("不支图片检测");
        }
        return imageList.get(0).checkImage(type, imageUrl);
    }


}
