package com.bxm.lovelink.common.dal.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.mapper.UserAuditMapper;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import com.bxm.lovelink.common.dal.user.audit.UserAuditHandlerManager;
import com.bxm.lovelink.common.push.Pusher;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import com.bxm.warcar.utils.NamedThreadFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * <p>
 * 用户资料审核 服务实现类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-20
 */
@Service
@Slf4j
public class UserAuditServiceImpl extends ServiceImpl<UserAuditMapper, UserAudit> implements IUserAuditService {

    private final UserAuditHandlerManager auditHandlerManager;
    private final ExecutorService executor;
    private final Pusher pusher;

    public UserAuditServiceImpl(UserAuditHandlerManager auditHandlerManager, @Lazy Pusher pusher) {
        this.auditHandlerManager = auditHandlerManager;
        this.pusher = pusher;
        this.executor = new ThreadPoolExecutor(20, 20, 0L, TimeUnit.MILLISECONDS,
                new LinkedBlockingQueue<>(), new NamedThreadFactory("user_audit"));
    }

    @Override
    public void createAudit(UserAudit userAudit) {
        boolean save = save(userAudit);
        if (save) {
            audit(userAudit);
        }
    }

    @Override
    public void audit(UserAudit userAudit) {
        if (userAudit == null || userAudit.getId() == null) {
            return;
        }
        executor.execute(() -> {
            try {
                Integer status = auditHandlerManager.auditHandle(userAudit);
                update(new LambdaUpdateWrapper<UserAudit>()
                        .eq(UserAudit::getId, userAudit.getId())
                        .eq(UserAudit::getAuditStatus, UserAudit.STATUS_WAIT)
                        .set(UserAudit::getAuditStatus, status));
                if(Objects.equals(status, UserAudit.STATUS_FAIL)){
                    PushTarget pushTarget =new PushTarget();
                    pushTarget.setUserId(userAudit.getUserId());
                    pusher.doImmediatePush(PushScene.HEAD_PICTURE_AUDIT_FAILE, pushTarget);
                }
            } catch (Exception e) {
                log.error("User audit error, userAudit:{}", JSON.toJSONString(userAudit));
            }
        });
    }

    @Override
    public UserAudit getLastOneAudit(UserAudit userAudit) {
        if (userAudit == null) {
            return null;
        }
        if (userAudit.getId() != null) {
            return getById(userAudit.getId());
        }
        return getOne(new LambdaQueryWrapper<UserAudit>()
                .eq(Objects.nonNull(userAudit.getConnectId()), UserAudit::getConnectId, userAudit.getConnectId())
                .eq(Objects.nonNull(userAudit.getUserId()), UserAudit::getUserId, userAudit.getUserId())
                .eq(Objects.nonNull(userAudit.getAuditBusiness()), UserAudit::getAuditBusiness, userAudit.getAuditBusiness())
                .eq(Objects.nonNull(userAudit.getAuditType()), UserAudit::getAuditType, userAudit.getAuditType())
                .orderByDesc(UserAudit::getId)
                .last("LIMIT 1"));
    }



}
