package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserCms;
import com.bxm.lovelink.common.dal.mapper.UserCmsMapper;
import com.bxm.lovelink.common.dal.service.IUserCmsService;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 用户cms信息 服务实现类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-29
 */
@Service
public class UserCmsServiceImpl extends ServiceImpl<UserCmsMapper, UserCms> implements IUserCmsService {

    @Override
    public UserCms getOneByUserId(Long userId) {
        return getOne(new LambdaQueryWrapper<UserCms>().eq(UserCms::getUserId, userId));
    }
}
