package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import com.bxm.lovelink.common.dal.entity.dto.user.UserLoveConditionDto;
import com.bxm.lovelink.common.dal.mapper.UserLoveConditionMapper;
import com.bxm.lovelink.common.dal.mapping.UserInfoMapping;
import com.bxm.lovelink.common.dal.service.IUserLoveConditionService;
import com.bxm.lovelink.common.enums.UserLoveConditionCompletionEnum;
import com.bxm.lovelink.common.event.user.UserCompleteStatusEvent;
import com.bxm.warcar.integration.eventbus.EventPark;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

/**
 * <p>
 * 用户理想伴侣信息 服务实现类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Service
@AllArgsConstructor
public class UserLoveConditionServiceImpl extends ServiceImpl<UserLoveConditionMapper, UserLoveCondition> implements IUserLoveConditionService {
    private final EventPark eventPark;


    @Override
    public UserLoveCondition getOneByUserId(Long userId) {
        return getOne(new LambdaQueryWrapper<UserLoveCondition>().eq(UserLoveCondition::getUserId, userId));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateByDto(UserLoveConditionDto dto, UserComposite composite) {
        UserLoveCondition condition = composite.getUserLoveCondition();
        UserLoveCondition userLoveCondition = UserInfoMapping.INSTANCE.dtoToDo(dto);
        userLoveCondition.setId(condition.getId());
        updateById(userLoveCondition);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateById(UserLoveCondition entity) {
        boolean result = super.updateById(entity);
        if (!result) {
            return false;
        }
        UserLoveCondition loveCondition = getById(entity.getId());
        Integer completion = UserLoveConditionCompletionEnum.calculateCompletion(loveCondition);
        super.updateById(new UserLoveCondition().setId(entity.getId()).setInfoCompleteProgress(completion));
        TransactionSynchronizationManager.registerSynchronization(new TransactionSynchronization() {
            @Override
            public void afterCommit() {
                eventPark.post(new UserCompleteStatusEvent(this, loveCondition.getUserId()));
            }
        });
        return true;
    }
}
