package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.mapper.UserOtherInfoMapper;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;

/**
 * <p>
 * 用户其他信息 服务实现类
 * </p>
 *
 * @author zhangdong
 * @since 2025-05-15
 */
@Service
public class UserOtherInfoServiceImpl extends ServiceImpl<UserOtherInfoMapper, UserOtherInfo> implements IUserOtherInfoService {

    @Override
    public UserOtherInfo getOneByUserId(Long userId) {
        return getOne(new LambdaQueryWrapper<UserOtherInfo>().eq(UserOtherInfo::getUserId, userId));
    }

    @Override
    public void incrPassiveLoveCount(Long targetUserId, Integer count) {
        baseMapper.incrPassiveLoveCount(targetUserId, count);
    }

    @Override
    public int getInviteUserCount(Long userId, Integer rewardStatus) {
        return baseMapper.getInviteUserCount(userId, rewardStatus);
    }

    @Override
    public void updateInfoFinishGiveStage(Long userId, Integer stage) {
        baseMapper.updateInfoFinishGiveStage(userId, stage);
    }

}
