package com.bxm.lovelink.common.dal.service.impl;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserComposite;
import com.bxm.lovelink.common.dal.entity.UserRuleTag;
import com.bxm.lovelink.common.dal.service.IUserRuleTagService;
import com.bxm.lovelink.common.enums.UserRuleTagEnum;
import com.bxm.lovelink.integration.ai.TextCompletionFacadeIntegration;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2025/6/6
 */
@Service
@AllArgsConstructor
public class UserRuleTagServiceImpl implements IUserRuleTagService {

    private final TextCompletionFacadeIntegration textCompletionFacadeIntegration;

    @Override
    public Map<Integer, UserRuleTag> calculate(UserComposite userComposite) {
        Map<Integer, UserRuleTag> map = UserRuleTagEnum.getUserRuleTags(userComposite)
                .stream().collect(Collectors.toMap(UserRuleTag::getType, x -> x));
        UserBasicInfo userBasicInfo = userComposite.getUserBasicInfo();
        if (StringUtils.isNotBlank(userBasicInfo.getJob())) {
            String system = "你是一位经验丰富的职业信息顾问，专门服务于婚恋社交平台。你的核心任务是评估用户提供的工作岗位信息相亲APP的个人公开主页上展示是否对他是加分项，直接输出：是或者否。\n" +
                    "评估目标： 判断该工作岗位的描述，如果直接展示在用户的公开相亲主页上，是否可能：\n" +
                    "1. 对用户在相亲过程中是否是加分项\n" +
                    "2. 违反保密要求或安全规定： 例如涉及国家机密、商业机密、敏感执法行动等。\n" +
                    "3. 引发不必要的偏见或负面印象： 例如某些容易被误解、存在刻板印象或社会接受度争议较大的职业（即使合法）。\n" +
                    "4. 暴露过多个人隐私或带来安全风险： 例如具体到可能被追踪的岗位地点、涉及高危或敏感人群接触的细节。\n" +
                    "5. 用户可能因社会压力或个人意愿而不愿公开： 例如某些传统观念中可能被视为“不体面”或用户自身感到尴尬的职业（需谨慎判断，避免强化偏见）。\n" +
                    "你的输入：\n" +
                    "● [用户提供的具体工作岗位]： 例如 “高级软件工程师”、“神经外科主治医师”、“自由职业者（主要接插画外包）”、“税务局稽查科科员”、“夜总会安保经理”、“个体户（经营一家成人用品网店）” 等。\n" +
                    "你的输出要求：\n" +
                    "6. 核心判断：\n" +
                    " ○ 是： 该岗位描述清晰、常见，社会接受度高，无明显隐私或安全风险，适合作为吸引点展示在公开主页。\n" +
                    " ○ 否： 不是加分项\n" +
                    "重要：仅输出“是”或者“否”！！";
            String query = "工作岗位：" + userBasicInfo.getJob();
            String data = textCompletionFacadeIntegration.chatInviteMessage(system, query);
            if (data.contains("是")) {
                map.put(UserRuleTagEnum.HIGH_JOB.getType(), new UserRuleTag()
                        .setType(UserRuleTagEnum.HIGH_JOB.getType())
                        .setName(userBasicInfo.getJob()));
            }
        }
        return map;
    }
}
