package com.bxm.lovelink.common.dal.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.UserVisitRecord;
import com.bxm.lovelink.common.dal.entity.dao.visit.UserVisitorListDao;
import com.bxm.lovelink.common.dal.entity.dto.heartbeat.UserClearUnReadDto;
import com.bxm.lovelink.common.dal.entity.dto.visit.VisitorQueryDto;
import com.bxm.lovelink.common.dal.entity.vo.visit.UserVisitorListVo;
import com.bxm.lovelink.common.dal.mapper.UserVisitRecordMapper;
import com.bxm.lovelink.common.dal.mapping.UserVisitMapping;
import com.bxm.lovelink.common.dal.service.IUserVisitRecordService;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;

/**
 * <p>
 * 用户访问记录表 服务实现类
 * </p>
 *
 * @author weixing
 * @since 2025-07-23
 */
@Service
public class UserVisitRecordServiceImpl extends ServiceImpl<UserVisitRecordMapper, UserVisitRecord> implements IUserVisitRecordService {
    @Override
    public IPage<UserVisitorListVo> visitorList(VisitorQueryDto dto) {
        dto.validateLocationIfRequired();
        int total = baseMapper.countVisitorList(dto);
        if (total == 0) {
            return new Page<>(dto.getCurrent(), dto.getSize());
        }
        int offset = (dto.getCurrent() - 1) * dto.getSize();
        List<UserVisitorListDao> visitorListDaoList = baseMapper.visitorList(dto, offset, dto.getSize());
        Page<UserVisitorListDao> visitorListDaoPage = new Page<>(dto.getCurrent(), dto.getSize(), total);
        visitorListDaoPage.setRecords(visitorListDaoList);
        Page<UserVisitorListVo> page = UserVisitMapping.INSTANCE.toPage(visitorListDaoPage);
        if (CollectionUtils.isEmpty(page.getRecords())) {
            return page;
        }
        buildVisitTitle(page.getRecords());
        return page;
    }

    private void buildVisitTitle(List<UserVisitorListVo> records) {
        for (UserVisitorListVo record : records) {
            Duration duration = Duration.between(record.getLastVisitTime(), LocalDateTime.now());
            long hours = duration.toHours();
            long days = duration.toDays();
            String title;
            if (record.getVisitCount() > 1) {
                title = record.getGenderName() + "近期反复看过你" + record.getVisitCount() + "次";
            } else {
                String timeDesc;
                if (days > 30) {
                    long months = days / 30;
                    timeDesc = months + "个月前";
                } else if (days >= 1) {
                    timeDesc = days + "天前";
                } else if (hours >= 1) {
                    timeDesc = hours + "小时前";
                } else {
                    timeDesc = "刚刚";
                }
                title = record.getGenderName() + timeDesc + "访问过你";
            }
            record.setTitle(title);
        }
    }

    @Override
    public void clearUnread(Long userId, UserClearUnReadDto dto) {
        LambdaUpdateWrapper<UserVisitRecord> lambdaUpdate = new LambdaUpdateWrapper<>();
        lambdaUpdate.eq(UserVisitRecord::getUserId, userId);
        lambdaUpdate.in(UserVisitRecord::getTargetUserId, dto.getTargetUserIds());
        lambdaUpdate.eq(UserVisitRecord::getReadStatus, Constants.NO);
        lambdaUpdate.set(UserVisitRecord::getReadStatus, Constants.YES);
        update(lambdaUpdate);
    }
}
