package com.bxm.lovelink.common.dal.service.impl.huawei;

import lombok.Data;

/**
 * @author Allen Hu
 * @date 2025/5/19
 */
@Data
public class AXBBindRequest {
    /**
     * X号码(关系号码)
     */
    private String relationNum;

    /**
     * A方真实号码(手机或固话)
     */
    private String callerNum;

    /**
     * B方真实号码(手机或固话)
     */
    private String calleeNum;

    /**
     * 城市码
     */
    private String areaCode;

    /**
     * 号码筛选方式
     */
    private Integer areaMatchMode;

    /**
     * 允许呼叫的方向
     */
    private Integer callDirection;

    /**
     * 绑定关系保持时间
     */
    private Integer duration;

    /**
     * 是否通话录音
     */
    private Boolean recordFlag;

    /**
     * 录音提示音
     */
    private String recordHintTone;

    /**
     * 单次通话最长时间
     */
    private Integer maxDuration;

    /**
     * 通话最后一分钟提示音
     */
    private String lastMinVoice;

    /**
     * 是否支持短信功能
     */
    private Boolean privateSms;

    /**
     * 个性化通话前等待音
     */
    private PreVoice preVoice;

    @Data
    public static class PreVoice {
        /**
         * 设置A拨打X号码时的通话前等待音
         */
        private String callerHintTone;

        /**
         * 设置B拨打X号码时的通话前等待音
         */
        private String calleeHintTone;
    }
}
