package com.bxm.lovelink.common.dal.strategy;


import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import com.bxm.warcar.integration.pair.Pair;
import com.bxm.warcar.utils.JsonHelper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * @author: weixing
 */
public abstract class AbstractRewardInsertCardStrategy implements InsertCardStrategy{
    @Autowired
    private Pair pair;

    /**
     * 获取次数配置
     */
    protected InviteConfig getInviteConfig() {
        InviteConfig inviteConfig = new InviteConfig();
        String data = pair.get(Constants.PairKey.INVITE_CONFIG).of();
        if (StringUtils.isNotBlank(data)) {
            return JsonHelper.convert(data, InviteConfig.class);
        }
        return inviteConfig;
    }
}
