package com.bxm.lovelink.common.dal.strategy;


import com.bxm.warcar.utils.JsonHelper;
import lombok.Data;
import lombok.experimental.Accessors;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: weixing
 */
@Data
public class InsertCardConfig {

    private Map<Integer, CardConfig> cardConfigMap;


    @Data
    @Accessors(chain = true)
    public static class CardConfig {

        /**
         * 位置余数
         */
        private Integer positionRemainder;
    }

    public static void main(String[] args) {
        InsertCardConfig insertCardConfig = new InsertCardConfig();
        Map<Integer, CardConfig> cardConfigMap = new HashMap<>();
        cardConfigMap.put(1, new CardConfig().setPositionRemainder(8));
        insertCardConfig.setCardConfigMap(cardConfigMap);
        System.out.println(JsonHelper.convert(insertCardConfig));
    }
}
