package com.bxm.lovelink.common.dal.strategy;


import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.constant.RedisKeys;
import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import com.bxm.warcar.cache.Counter;
import com.bxm.warcar.cache.KeyGenerator;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * @author: weixing
 */
@Component
@RequiredArgsConstructor
public class InviteInsertCardStrategy extends AbstractRewardInsertCardStrategy {
    private final Counter counter;

    @Override
    public Integer getCardType() {
        return Constants.CardType.INVITE;
    }

    @Override
    public List<InsertCard> computeInsertCards(InsertCardContext context) {
        List<InsertCard> result = new ArrayList<>();

        String date = LocalDate.now().format(DateTimeFormatter.BASIC_ISO_DATE);
        KeyGenerator inviteUserRewardCountKey = RedisKeys.inviteUserRewardCount(context.getUserId());
        // 用户可用的次数
        Long inviteBrowseCount = ObjectUtils.defaultIfNull(counter.hget(inviteUserRewardCountKey, date), 0L);
        InviteConfig inviteConfig = getInviteConfig();
        int totalLimit = inviteConfig.getBasicBrowseCount() + inviteBrowseCount.intValue();
        int todaySwipeCount = context.getTodaySwipeCount() + ObjectUtils.defaultIfNull(context.getWaitSwipeCount(), 0);
        int requestSize = context.getRequestSize();

        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + requestSize;

        int cardTriggerSwipe = totalLimit + 1;

        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, getCardType(), Constants.CardSubType.INVITE, Constants.SwipeEffect.FIXED));
        } else if (cardTriggerSwipe < startSwipe) {
            // 临界点已过，但之前没插，这次补在最前
            result.add(new InsertCard(0, getCardType(), Constants.CardSubType.INVITE, Constants.SwipeEffect.FIXED));
        }
        Set<Integer> set = new HashSet<>();
        return result.stream()
                .filter(card -> set.add(card.getIndex()))
                .collect(Collectors.toList());
    }

    public static void main(String[] args) {
        List<InsertCard> result = new ArrayList<>();
        int requestSize = 5;
        int todaySwipeCount = 30;
        int totalLimit = 30;

        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + requestSize;

        int cardTriggerSwipe = totalLimit + 1;

        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, 1, Constants.CardSubType.INVITE, Constants.SwipeEffect.ALLOW_SWIPE));
        } else if (cardTriggerSwipe < startSwipe) {
            // 临界点已过，但之前没插，这次补在最前
            result.add(new InsertCard(0, 1, Constants.CardSubType.INVITE, Constants.SwipeEffect.ALLOW_SWIPE));
        }
        System.out.println( result);
    }

    @Override
    public Integer getSort() {
        return 1;
    }
}
