package com.bxm.lovelink.common.dal.strategy;


import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.InsertCard;
import com.bxm.lovelink.common.dal.entity.InsertCardContext;
import com.bxm.lovelink.common.dal.entity.InviteConfig;
import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author: weixing
 */
@Component
@RequiredArgsConstructor
public class RealNameInsertCardStrategy extends AbstractRewardInsertCardStrategy{

    @Override
    public Integer getCardType() {
        return Constants.CardType.REAL_NAME;
    }

    @Override
    public List<InsertCard> computeInsertCards(InsertCardContext context) {
        List<InsertCard> result = new ArrayList<>();
        if (context.getRealName()) {
            return result;
        }
        InviteConfig inviteConfig = getInviteConfig();
        int totalLimit = inviteConfig.getNoCertBrowseCount();
        int todaySwipeCount = context.getTodaySwipeCount() + ObjectUtils.defaultIfNull(context.getWaitSwipeCount(), 0);

        int startSwipe = todaySwipeCount + 1;
        int endSwipe = todaySwipeCount + context.getRequestSize();

        int cardTriggerSwipe = totalLimit + 1;

        if (cardTriggerSwipe >= startSwipe && cardTriggerSwipe <= endSwipe) {
            int insertIndex = cardTriggerSwipe - todaySwipeCount - 1;
            result.add(new InsertCard(insertIndex, getCardType(), Constants.CardSubType.REAL_NAME, Constants.SwipeEffect.REBOUNCE));
        }
        return result;
    }

    @Override
    public Integer getSort() {
        return 2;
    }
}
