package com.bxm.lovelink.common.dal.user.audit;

import com.bxm.lovelink.common.dal.entity.UserAudit;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * @author zhangdong
 * @date 2025/5/26
 */
@Component
public class UserAuditHandlerManager implements ApplicationListener<ApplicationReadyEvent> {

    private final Map<Integer, UserAuditHandler> handlerMap = new ConcurrentHashMap<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        Map<String, UserAuditHandler> beansOfType = applicationContext.getBeansOfType(UserAuditHandler.class);
        beansOfType.forEach((name, handler) -> handlerMap.put(handler.auditType(), handler));
    }

    public Integer auditHandle(UserAudit userAudit) {
        UserAuditHandler handler = handlerMap.get(userAudit.getAuditType());
        if (handler == null) {
            throw new IllegalArgumentException("No handler found for audit type: " + userAudit.getAuditType());
        }
        return handler.auditHandle(userAudit);
    }
}
