package com.bxm.lovelink.common.dal.user.audit;

import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageResult;
import com.bxm.lovelink.common.integration.sensitive.SensitiveImageType;
import org.springframework.stereotype.Component;

/**
 * @author zhangdong
 * @date 2025/5/26
 */
@Component
public class UserAuditImageHandler implements UserAuditHandler {

    private final ISensitiveService sensitiveService;

    public UserAuditImageHandler(ISensitiveService sensitiveService) {
        this.sensitiveService = sensitiveService;
    }

    @Override
    public Integer auditType() {
        return UserAudit.TYPE_IMAGE;
    }

    @Override
    public Integer auditHandle(UserAudit userAudit) {
        SensitiveImageResult result = sensitiveService.checkImage(SensitiveImageType.AVATAR, userAudit.getAuditContent());
        int status = UserAudit.STATUS_PASS;
        if (result.getHit()) {
            status = UserAudit.STATUS_FAIL;
        }
        return status;
    }
}
