package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserAudit;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.IUserAuditService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * 头像审核
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoAvatarAuditBuilder implements UserBasicInfoBuilder {

    private final IUserAuditService userAuditService;

    public UserBasicInfoAvatarAuditBuilder(IUserAuditService userAuditService) {
        this.userAuditService = userAuditService;
    }


    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        String image = userBasicInfo.getOriginalImage();
        if (StringUtils.isBlank(image)) {
            return;
        }
        UserAudit lastOneAudit = userAuditService.getLastOneAudit(new UserAudit()
                .setConnectId(userBasicInfo.getId())
                .setUserId(userBasicInfo.getUserId())
                .setAuditBusiness(UserAudit.AUDIT_BUSINESS_AVATAR));
        if (lastOneAudit != null && lastOneAudit.isWait()) {
            throw new IllegalArgumentException("存在未审核结束的头像，请等待审核通过后再进行头像上传！");
        }
        UserAudit userAudit = new UserAudit()
                .setAuditType(UserAudit.TYPE_IMAGE)
                .setAuditAuto(UserAudit.AUDIT_AUTO)
                .setAuditBusiness(UserAudit.AUDIT_BUSINESS_AVATAR)
                .setAuditContent(image)
                .setUserId(userBasicInfo.getUserId())
                .setConnectId(userBasicInfo.getId());
        userAuditService.createAudit(userAudit);
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.AVATAR_AUDIT.getCode();
    }
}
