package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.contant.UserConstants.UserConstellationEnum;
import com.bxm.lovelink.common.contant.UserConstants.UserZodiacEnum;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

/**
 * 出生年月日构建器
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoBirthdayBuilder implements UserBasicInfoBuilder {

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        LocalDate birthday = userBasicInfo.getBirthday();
        if (birthday == null) {
            return;
        }
        //计算生肖
        userBasicInfo.setZodiac(UserZodiacEnum.getByBirthday(birthday).getCode());
        //计算星座
        UserConstellationEnum x = UserConstellationEnum.getByBirthday(birthday);
        if (x != null) {
            userBasicInfo.setConstellation(x.getCode());
        }
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.BIRTHDAY.getCode();
    }
}
