package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoBuilderChain implements ApplicationListener<ApplicationReadyEvent> {
    private final List<UserBasicInfoBuilder> builderList = new ArrayList<>();

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableApplicationContext applicationContext = event.getApplicationContext();
        builderList.addAll(applicationContext.getBeansOfType(UserBasicInfoBuilder.class).values().stream().sorted(Comparator.comparingInt(UserBasicInfoBuilder::getOrder)).collect(Collectors.toList()));
    }

    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        for (UserBasicInfoBuilder builder : builderList) {
            builder.buildAndCheck(context, userBasicInfo);
        }
    }
}
