package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import org.springframework.stereotype.Component;

/**
 * 不能修改的基础信息构建器
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoNoUpdateBuilder implements UserBasicInfoBuilder {
    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        UserBasicInfo existBasicInfo = context.getExistBasicInfo();
        if (existBasicInfo.getBirthday() != null) {
            userBasicInfo.setBirthday(null);
        }
        if (existBasicInfo.getGender() != null) {
            userBasicInfo.setGender(null);
        }
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.NO_UPDATE.getCode();
    }
}
