package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.integration.geo.GaoDeoIntegration;
import org.springframework.stereotype.Component;

/**
 * 逆地理编码解析
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoReGeoBuilder implements UserBasicInfoBuilder {

    private final GaoDeoIntegration gaoDeoIntegration;


    public UserBasicInfoReGeoBuilder(GaoDeoIntegration gaoDeoIntegration) {
        this.gaoDeoIntegration = gaoDeoIntegration;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        Double longitude = userBasicInfo.getLongitude();
        Double latitude = userBasicInfo.getLatitude();
        if (longitude == null || latitude == null) {
            return;
        }
        Integer district = gaoDeoIntegration.reGeo(longitude, latitude);
        userBasicInfo.setLastLoginDistrict(district);
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.RE_GEO.getCode();
    }
}
