package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.dal.entity.UserAboutMe;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.service.ISensitiveService;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 昵称构建器
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserBasicInfoSensitiveBuilder implements UserBasicInfoBuilder {

    private final ISensitiveService sensitiveService;

    public UserBasicInfoSensitiveBuilder(ISensitiveService sensitiveService) {
        this.sensitiveService = sensitiveService;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        String nickname = userBasicInfo.getNickname();
        if (StringUtils.isNotBlank(nickname)) {
            SensitiveTextResult sensitiveTextResult = sensitiveService.checkText(nickname);
            if (sensitiveTextResult.getHit()) {
                throw new IllegalArgumentException("昵称中包含敏感词汇");
            }
        }
        String job = userBasicInfo.getJob();
        if (StringUtils.isNotBlank(job)) {
            SensitiveTextResult sensitiveTextResult = sensitiveService.checkText(job);
            if (sensitiveTextResult.getHit()) {
                throw new IllegalArgumentException("工作中包含敏感词汇");
            }
        }
        List<UserAboutMe> aboutMe = userBasicInfo.getAboutMe();
        if (CollectionUtils.isNotEmpty(aboutMe)) {
            for (UserAboutMe userAboutMe : aboutMe) {
                SensitiveTextResult sensitiveTextResult = sensitiveService.checkText(userAboutMe.getContent());
                if (sensitiveTextResult.getHit()) {
                    throw new IllegalArgumentException("关于我内容中包含敏感词");
                }
            }

        }
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.SENSITIVE.getCode();
    }
}
