package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.UserOtherInfo;
import com.bxm.lovelink.common.dal.entity.dto.user.UserBasicInfoDto;
import com.bxm.lovelink.common.dal.service.IUserOtherInfoService;
import com.bxm.lovelink.common.integration.geo.GaoDeoIntegration;
import com.bxm.warcar.ip.IP;
import com.bxm.warcar.ip.IpLibrary;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 其他信息
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
public class UserOtherInfoBuilder implements UserBasicInfoBuilder {

    private final IUserOtherInfoService userOtherInfoService;
    private final IpLibrary ipLibrary;
    private final GaoDeoIntegration gaoDeoIntegration;


    public UserOtherInfoBuilder(IUserOtherInfoService userOtherInfoService, @Qualifier("aliyunIpLibrary") IpLibrary ipLibrary, GaoDeoIntegration gaoDeoIntegration) {
        this.userOtherInfoService = userOtherInfoService;
        this.ipLibrary = ipLibrary;
        this.gaoDeoIntegration = gaoDeoIntegration;
    }

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        UserOtherInfo userOtherInfo = context.getUserComposite().getUserOtherInfo();
        UserBasicInfoDto basicInfoDto = context.getBasicInfoDto();
        UserOtherInfo update = new UserOtherInfo().setId(userBasicInfo.getId());
        boolean register = false;
        if (userOtherInfo.getRegisterPlaceDistrict() == null && userBasicInfo.getCurrentPlaceDistrict() != null) {
            register = true;
            update.setRegisterPlaceDistrict(userBasicInfo.getCurrentPlaceDistrict());
        }
        if (StringUtils.isEmpty(userOtherInfo.getRegisterIp()) && Objects.equals(basicInfoDto.getRegisterFinished(), Constants.YES)
                && StringUtils.isNotEmpty(basicInfoDto.getIp())) {
            register = true;
            IP ip = ipLibrary.find(basicInfoDto.getIp());
            update.setRegisterIp(basicInfoDto.getIp());
            if (ip != null && StringUtils.isNotBlank(ip.getLatitude()) && StringUtils.isNotBlank(ip.getLongitude())) {
                Integer district = gaoDeoIntegration.reGeo(Double.valueOf(ip.getLongitude()), Double.valueOf(ip.getLatitude()));
                update.setRegisterIpPlaceDistrict(district);
            }
        }
        if (register) {
            userOtherInfoService.updateById(update);
        }
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.USER_OTHER_INFO.getCode();
    }
}
