package com.bxm.lovelink.common.dal.user.basicinfo;

import com.bxm.lovelink.common.contant.Constants;
import com.bxm.lovelink.common.dal.entity.User;
import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.dto.user.UserBasicInfoDto;
import com.bxm.lovelink.common.dal.service.IUserService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 注册完成
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Component
@AllArgsConstructor
public class UserRegisterFinishBuilder implements UserBasicInfoBuilder {

    private final IUserService userService;

    @Override
    public void buildAndCheck(UserBasicInfoBuilderContext context, UserBasicInfo userBasicInfo) {
        UserBasicInfoDto dto = context.getBasicInfoDto();
        if (Objects.equals(dto.getRegisterFinished(), Constants.YES)) {
            userService.updateById(new User().setId(context.getUserComposite().getUser().getId()).setRegisterFinished(Constants.YES));
        }
    }

    @Override
    public int getOrder() {
        return BuilderSortEnum.REGISTER_FINISH.getCode();
    }
}
