package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.contant.Constants;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 *
 * @author tangxiao
 * @date 2025/5/15
 * @since 1.0
 */
@Getter
@AllArgsConstructor
public enum TicketRecordTypeEnum {

    USE(1, Constants.MeetTicketRecord.CATEGORY_USE, "支出"),
    RETURN(2, Constants.MeetTicketRecord.CATEGORY_RETURN, "退回"),
    RECHARGE_NORMAL(3, Constants.MeetTicketRecord.CATEGORY_CHARGE, "普通卡充值"),
    RECHARGE_VIP(4, Constants.MeetTicketRecord.CATEGORY_CHARGE, "vip卡充值"),
    COMPLETE_INFO_RECHARGE(5, Constants.MeetTicketRecord.CATEGORY_CHARGE, "完善资料");

    private final Integer ordinal;
    private final Integer category;
    private final String desc;

    public static TicketRecordTypeEnum of(Integer ordinal) {
        for (TicketRecordTypeEnum value : values()) {
            if (value.ordinal.equals(ordinal)) {
                return value;
            }
        }
        return null;
    }
}
