package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.contant.Constants;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 红豆退回枚举
 * @author tangxiao
 * @date 2025/5/17
 * @since 1.0
 */
@AllArgsConstructor
@Getter
public enum TicketReturnTypeEnum {

    TIME_OUT(1, String.format("超%s小时未确认", Constants.MeetGroupConst.INVITE_EXPIRE_TIME_HOUR)),
    REFUSE(2, "婉拒"),
    MEET_FAIL(3, "见面失败");

    private final Integer ordinal;
    private final  String desc;

    public static TicketReturnTypeEnum of(Integer ordinal) {
        for (TicketReturnTypeEnum value : values()) {
            if (value.ordinal.equals(ordinal)) {
                return value;
            }
        }
        return null;
    }
}
