package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.function.Function;

/**
 * @author zhangdong
 * @date 2025/5/16
 */
@AllArgsConstructor
@Getter
public enum UserBasicInfoCompletionEnum {


    NICKNAME_IMAGE("昵称头像", userBasicInfo -> StringUtils.isNotBlank(userBasicInfo.getNickname()) && StringUtils.isNotBlank(userBasicInfo.getAvatar())),
    VOICE("声音", userBasicInfo -> StringUtils.isNotBlank(userBasicInfo.getVoice())),

    ALBUM("相册", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getAlbum())),

    ABOUT_ME("关于我", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getAboutMe())),

    LOVE_GOAL("恋爱目标", userBasicInfo -> userBasicInfo.getLoveGoal() != null),

    BASIC("基础信息", userBasicInfo -> userBasicInfo.getBirthday() != null && userBasicInfo.getHeight() != null
            && userBasicInfo.getCurrentPlaceDistrict() != null
            && userBasicInfo.getNativePlaceDistrict() != null
            && userBasicInfo.getGender() != null && userBasicInfo.getMarriage() != null
            && StringUtils.isNotBlank(userBasicInfo.getWechatNumber())
            && userBasicInfo.getChildren() != null && StringUtils.isNotBlank(userBasicInfo.getSchoolName())
            && userBasicInfo.getEduHighest() != null && StringUtils.isNotBlank(userBasicInfo.getIndustry())
            && StringUtils.isNotBlank(userBasicInfo.getJob()) && userBasicInfo.getYearRevenue() != null
            && userBasicInfo.getCar() != null && userBasicInfo.getHouse() != null),
    INTEREST("兴趣爱好", userBasicInfo -> CollectionUtils.isNotEmpty(userBasicInfo.getInterestTag())),

    ;

    private final String desc;

    private final Function<UserBasicInfo, Boolean> infoCompletion;


    public static Integer calculateCompletion(UserBasicInfo userBasicInfo) {
        int size = 0;
        int len = UserBasicInfoCompletionEnum.values().length;
        for (UserBasicInfoCompletionEnum completionEnum : UserBasicInfoCompletionEnum.values()) {
            if (completionEnum.infoCompletion.apply(userBasicInfo)) {
                size++;
            }
        }
        if (size == len) {
            return 100;
        }
        return 100 / len * size;
    }

}
