package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import com.bxm.lovelink.common.dal.entity.bo.CalculateUserLoveConditionBo;
import com.bxm.lovelink.common.dal.entity.vo.user.UserLoveConditionRangeVo;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.function.Function;

/**
 * @author zhangdong
 * @date 2025/5/19
 */
@AllArgsConstructor
@Getter
public enum UserLoveConditionCalculateEnum {

    AGE(1, o -> {
        int age = (Integer) o.getValue();
        return new UserLoveConditionRangeVo().setMin(age - 5).setMax(age + 5);
    }),

    HEIGHT(2, o -> {
        int height = (Integer) o.getValue();
        UserBasicInfo userBasicInfo = o.getUserComposite().getUserBasicInfo();
        if (userBasicInfo.isMan()) {
            return new UserLoveConditionRangeVo().setMin(height - 10).setMax(height);
        }
        return new UserLoveConditionRangeVo().setMin(height - 5).setMax(height + 15);
    }),


    ;


    private final Integer type;

    private final Function<CalculateUserLoveConditionBo, UserLoveConditionRangeVo> calculateCondition;


    public static UserLoveConditionCalculateEnum getEnumByType(Integer type) {
        for (UserLoveConditionCalculateEnum e : values()) {
            if (e.getType().equals(type)) {
                return e;
            }
        }
        return null;
    }

}
