package com.bxm.lovelink.common.enums;

import com.bxm.lovelink.common.dal.entity.UserLoveCondition;
import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;
import java.util.function.Function;

/**
 * @author zhangdong
 * @date 2025/5/16
 */
@AllArgsConstructor
@Getter
public enum UserLoveConditionCompletionEnum {
    HEIGHT("身高", loveCondition -> loveCondition.getHeightRangeMin() != null && loveCondition.getHeightRangeMax() != null),
    AGE("年龄", loveCondition -> loveCondition.getAgeRangeMin() != null && loveCondition.getAgeRangeMax() != null),
    EDU("学历", loveCondition -> notNull(loveCondition.getEduRange())),
//    MARRIAGE("婚姻状况", loveCondition -> notNull(loveCondition.getMarriageChildrenRange())),
//    JOB("工作", loveCondition -> notNull(loveCondition.getJobRange()) && notNull(loveCondition.getIndustryRange())
//            && notNull(loveCondition.getLifeRange())),
    YEAR_INCOME("年收入", loveCondition -> notNull(loveCondition.getYearRevenueRange())),
    CAR("车", loveCondition -> notNull(loveCondition.getCarRange())),
    HOUSE("房", loveCondition -> notNull(loveCondition.getHouseRange())),
//    PLACE("籍贯", loveCondition -> notNull(loveCondition.getNativePlaceRange())),
//    SMOKE("抽烟", loveCondition -> notNull(loveCondition.getSmokeStatusRange())),
//    TATTOO("纹身", loveCondition -> notNull(loveCondition.getTattooStatusRange())),
//    LOVE_GOAL("恋爱目标", loveCondition -> notNull(loveCondition.getLoveGoalRange())),
//    BODY("身材", loveCondition -> notNull(loveCondition.getBodyShapeRange())),
    ;

    private final String desc;

    private final Function<UserLoveCondition, Boolean> infoCompletion;


    public static Integer calculateCompletion(UserLoveCondition loveCondition) {
        int size = 0;
        int len = UserLoveConditionCompletionEnum.values().length;
        for (UserLoveConditionCompletionEnum completionEnum : UserLoveConditionCompletionEnum.values()) {
            if (completionEnum.infoCompletion.apply(loveCondition)) {
                size++;
            }
        }
        if (size == len) {
            return 100;
        }
        return 100 / len * size;
    }

    private static boolean notNull(List<Integer> value) {
        return CollectionUtils.isNotEmpty(value);
    }

}
