package com.bxm.lovelink.common.event.chat;

import com.bxm.lovelink.common.chat.ChatStat;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.entity.ChatSessionMessage;
import com.bxm.lovelink.common.dal.entity.User;
import lombok.Builder;
import lombok.Getter;

import java.util.EventObject;
import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/6/26
 */
@Getter
public class ChatCompletionEvent extends EventObject {

    private User user;
    private ChatSession chatSession;
    private List<ChatSessionMessage> chatSessionMessages;
    private String reasoningContent;
    private String content;
    private ChatStat chatStat;

    public ChatCompletionEvent(Object source, User user, ChatSession chatSession, List<ChatSessionMessage> chatSessionMessages, String reasoningContent, String content, ChatStat chatStat) {
        super(source);
        this.user = user;
        this.chatSession = chatSession;
        this.chatSessionMessages = chatSessionMessages;
        this.reasoningContent = reasoningContent;
        this.content = content;
        this.chatStat = chatStat;
    }
}
