package com.bxm.lovelink.common.event.meet;

import com.bxm.lovelink.common.dal.entity.MeetGroup;
import com.bxm.lovelink.common.dal.entity.dao.MeetGroupDao;
import lombok.Getter;

import java.util.EventObject;

/**
 * 见面群事件
 *
 * @author Allen Hu
 * @date 2025/5/21
 */
@Getter
public class MeetGroupEvent extends EventObject {

    private final MeetGroup meetGroup;

    // 超时情况下是空的
    private final Long currentUserId;

    public MeetGroupEvent(Object source, MeetGroup meetGroup, Long currentUserId) {
        super(source);
        this.meetGroup = meetGroup;
        this.currentUserId = currentUserId;
    }
}
