package com.bxm.lovelink.common.event.meet;

import com.bxm.lovelink.common.dal.entity.MeetGroupMessage;
import lombok.Getter;

import java.util.EventObject;

/**
 * 发送见面群新消息事件。
 *
 * @author Allen Hu
 * @date 2025/5/21
 */
@Getter
public class MeetGroupNewMessageEvent extends EventObject {

    /**
     * 消息
     */
    private final MeetGroupMessage message;
    /**
     * 接收消息通知的人
     */
    private final Long receiverUserId;

    public MeetGroupNewMessageEvent(Object source, MeetGroupMessage message, Long receiverUserId) {
        super(source);
        this.message = message;
        this.receiverUserId = receiverUserId;
    }
}
