package com.bxm.lovelink.common.event.user;

import com.bxm.lovelink.common.dal.entity.UserBasicInfo;
import lombok.Getter;

import java.util.EventObject;

/**
 * 用户基础信息修改事件
 *
 * @date 2025/6/16
 */
@Getter
public class UserBasicInfoUpdateEvent extends EventObject {

    private final UserBasicInfo userBasicInfo;

    private final Long userId;

    public UserBasicInfoUpdateEvent(Object source, Long userId, UserBasicInfo userBasicInfo) {
        super(source);
        this.userId = userId;
        this.userBasicInfo = userBasicInfo;
    }
}
