package com.bxm.lovelink.common.event.user;

import com.bxm.lovelink.common.dal.entity.UserComposite;
import lombok.Getter;

import java.util.EventObject;

/**
 * 用户注销事件
 *
 * @date 2025/6/16
 */
@Getter
public class UserCancelEvent extends EventObject {

    private final UserComposite userComposite;

    private final Long userId;

    public UserCancelEvent(Object source, Long userId, UserComposite userComposite) {
        super(source);
        this.userId = userId;
        this.userComposite = userComposite;
    }
}
