package com.bxm.lovelink.common.handler;


import com.bxm.lovelink.common.utils.BitCalculateUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 * @author zhangdong
 * @date 2025/5/17
 */
public class BitIntegerListTypeHandler extends BaseTypeHandler<List<Integer>> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, List<Integer> parameter, JdbcType jdbcType) throws SQLException {
        ps.setInt(i, BitCalculateUtils.calculate(parameter));
    }

    @Override
    public List<Integer> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        int data = rs.getInt(columnName);
        return BitCalculateUtils.reverseCalculate(data);
    }

    @Override
    public List<Integer> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        int data = rs.getInt(columnIndex);
        return BitCalculateUtils.reverseCalculate(data);
    }

    @Override
    public List<Integer> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        int data = cs.getInt(columnIndex);
        return BitCalculateUtils.reverseCalculate(data);
    }
}

