package com.bxm.lovelink.common.handler;


import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.dal.entity.GuestRecommend;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author: weixing
 */
public class GuestRecommendTypeHandler extends BaseTypeHandler<GuestRecommend> {
    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, GuestRecommend parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JSON.toJSONString(parameter));
    }

    @Override
    public GuestRecommend getNullableResult(ResultSet rs, String columnName) throws SQLException {
        String json = rs.getString(columnName);
        return json == null ? null : JSON.parseObject(json, GuestRecommend.class);
    }

    @Override
    public GuestRecommend getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        String json = rs.getString(columnIndex);
        return json == null ? null : JSON.parseObject(json, GuestRecommend.class);
    }

    @Override
    public GuestRecommend getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        String json = cs.getString(columnIndex);
        return json == null ? null : JSON.parseObject(json, GuestRecommend.class);
    }
}
