package com.bxm.lovelink.common.integration.geo;

import lombok.Data;
import lombok.experimental.Accessors;

/**
 * @author zhangdong
 * @date 2025/5/17
 */
@Data
@Accessors(chain = true)
public class GaoDeReGeoResult {

    private Integer status;

    private ReGeoCode regeocode;


    @Data
    @Accessors(chain = true)
    public static class ReGeoCode {
        private AddressComponent addressComponent;

        @Data
        @Accessors(chain = true)
        public static class AddressComponent {
            private Integer adcode;
        }
    }

    public boolean isSuccess() {
        return status == 1 && regeocode != null && regeocode.getAddressComponent() != null;
    }

    public Integer getAdcode() {
        return regeocode.getAddressComponent().getAdcode();
    }
}
