package com.bxm.lovelink.common.integration.geo;

import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

/**
 * @author zhangdong
 * @date 2025/5/24
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(GaoDeProperties.class)
public class GaoDeoIntegration {

    private final HttpClient httpClient;
    private final GaoDeProperties properties;
    private static final String RE_GEO = "https://restapi.amap.com/v3/geocode/regeo";


    public GaoDeoIntegration(GaoDeProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient(50, 50, 5000, 5000, 5000);
    }

    public Integer reGeo(Double longitude, Double latitude) {
        String url = RE_GEO + "?key=" + properties.getKey() + "&location=" + longitude + "," + latitude;
        HttpGet get = new HttpGet(url);
        String errorMessage = "reGeo error";
        try {
            HttpResponse response = httpClient.execute(get);
            int statusCode = response.getStatusLine().getStatusCode();
            String body = EntityUtils.toString(response.getEntity());
            if (statusCode != 200 || StringUtils.isBlank(body)) {
                log.error(errorMessage + ",statusCode: {},longitude:{},latitude:{},response:{}", statusCode, longitude, latitude, body);
                throw new BusinessException(errorMessage);
            }
            GaoDeReGeoResult rs = JsonHelper.convert(body, GaoDeReGeoResult.class);
            if (!rs.isSuccess()) {
                log.error(errorMessage + ",longitude:{},latitude:{},response:{}", longitude, latitude, body);
                throw new BusinessException(errorMessage);
            }
            return rs.getAdcode();
        } catch (BusinessException e) {
            throw e;
        } catch (Exception e) {
            log.error(errorMessage + ",longitude:{},latitude:{}", longitude, latitude, e);
            throw new BusinessException(errorMessage);
        } finally {
            get.releaseConnection();
        }
    }


}
