package com.bxm.lovelink.common.integration.sensitive;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

/**
 * @author zhangdong
 * @date 2025/6/11
 */
@Slf4j
@Aspect
@Component
public class SensitiveAspect implements MeterBinder {

    private MeterRegistry registry;

    @Override
    public void bindTo(@NonNull MeterRegistry registry) {
        this.registry = registry;
    }

    @Around("execution(* com.bxm.lovelink.common.integration.sensitive.SensitiveImageIntegration.checkImage(..))")
    public Object aroundImage(ProceedingJoinPoint point) throws Throwable {
        return around0(point, 1);
    }

    @Around("execution(* com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration.checkText(..))")
    public Object aroundText(ProceedingJoinPoint point) throws Throwable {
        return around0(point, 2);
    }

    public Object around0(ProceedingJoinPoint point, Integer business) throws Throwable {
        String name = point.getTarget().getClass().getName();
        name = name.substring(name.lastIndexOf(".") + 1);
        long start = System.nanoTime();
        int status = 1;
        try {
            return point.proceed();
        } catch (Exception e) {
            status = 0;
            throw e;
        } finally {
            Timer.builder("sensitive.execute")
                    .tag("type", name)
                    .tag("business", String.valueOf(business))
                    .tag("status", String.valueOf(status))
                    .register(this.registry).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        }
    }
}
