package com.bxm.lovelink.common.integration.sensitive.nut;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextIntegration;
import com.bxm.lovelink.common.integration.sensitive.SensitiveTextResult;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import java.nio.charset.StandardCharsets;

/**
 * 敏感词
 *
 * @author zhangdong
 * @date 2025/5/17
 */
@Slf4j
@Component
@ConditionalOnProperty(prefix = "sensitive.nut-wall", name = "enable", havingValue = "true")
public class NutWallSensitiveIntegration implements SensitiveTextIntegration {
    private final NutWallSensitiveProperties properties;
    private final HttpClient httpClient;

    public NutWallSensitiveIntegration(NutWallSensitiveProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient(50, 50, 5000, 5000, 5000);
    }

    @Override
    public SensitiveTextResult checkText(String text) {
        NutWallTextSensitiveRequest request = new NutWallTextSensitiveRequest()
                .setContent(text);
        HttpPost post = new HttpPost(properties.getUrl());
        post.setEntity(new StringEntity(JSON.toJSONString(request), StandardCharsets.UTF_8));
        post.addHeader("content-type", "application/json;charset=utf-8");
        String errorMessage = "text check error";
        try {
            HttpResponse response = httpClient.execute(post);
            String body = EntityUtils.toString(response.getEntity());
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK || StringUtils.isBlank(body)) {
                log.error(errorMessage + ",statusCode: {},text: {}, response: {}", statusCode, text, body);
                throw new BusinessException(errorMessage);
            }
            NutWallTextSensitiveResponse rs = JsonHelper.convert(body, NutWallTextSensitiveResponse.class);
            if (!"0".equals(rs.getCode())) {
                log.error(errorMessage + ",text: {},response: {}", text, body);
                throw new BusinessException(errorMessage);
            }
            return new SensitiveTextResult()
                    .setHit(CollectionUtils.isNotEmpty(rs.getWord_list()))
                    .setText(rs.getReturn_str());
        } catch (BusinessException e) {
            throw e;
        } catch (Exception e) {
            log.error(errorMessage + ",text: {}", text, e);
            throw new BusinessException(errorMessage);
        } finally {
            post.releaseConnection();
        }
    }


}
