package com.bxm.lovelink.common.integration.uni.push;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.integration.uni.UniProperties;
import com.bxm.warcar.utils.HttpClientHelper;
import com.bxm.warcar.utils.JsonHelper;
import com.bxm.warcar.utils.NamedThreadFactory;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpHeaders;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

/**
 * @author dll
 * @date 2025/6/17
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(UniProperties.class)
public class UniPushIntegration {

    private final HttpClient httpClient;
    private final UniProperties properties;

    private final ThreadPoolExecutor executor = new ThreadPoolExecutor(100, 100, 0,
            TimeUnit.SECONDS, new LinkedBlockingQueue<>(1000), new NamedThreadFactory("uniapp-push"));

    public UniPushIntegration(UniProperties properties) {
        this.properties = properties;
        this.httpClient = HttpClientHelper.createHttpClient(500, 500,
                2000, 1000, 2000);
    }

    public void push(UniappPushMsgRequest uniappPushMsgRequest) {
        HttpPost post = new HttpPost(properties.getDomain() + "nuannuan/sendMessage");
        try {
            post.addHeader(HttpHeaders.CONTENT_TYPE, MediaType.APPLICATION_JSON_UTF8_VALUE);
            post.addHeader(properties.getAuthHeaderName(), properties.getAuthHeaderValue());
            post.setEntity(new StringEntity(JsonHelper.convert(uniappPushMsgRequest), StandardCharsets.UTF_8));
            HttpResponse response = httpClient.execute(post);
            int statusCode = response.getStatusLine().getStatusCode();
            //{"data":{"RASS_0618_2e9f2773d4d735b0a2c4c3ad20ce9c13":{"747b4e9677696099e8af49b96fae7ea5":"successed_online"}},"errCode":0,"errMsg":"success"}
            String body = EntityUtils.toString(response.getEntity());

            if (statusCode != 200 || StringUtils.isBlank(body)) {
                log.error("状态码不对");
            }
            UniappResult rs = JsonHelper.convert(body, UniappResult.class);
            if (!rs.isSuccess()) {
                log.error("UniappResult  return error,{}", body);
            }
            log.info("request params is {}, result body {}", JSON.toJSONString(uniappPushMsgRequest), JSON.toJSONString(body));
        } catch (Exception e) {
            log.error("UniappResult Exception", e);
        } finally {
            post.releaseConnection();
        }
    }

    public static void main(String[] args) {
        /*UniappPushMsgRequest uniappPushMsgRequest=new UniappPushMsgRequest();
        uniappPushMsgRequest.setContent("测试内容");
        uniappPushMsgRequest.setTitle("测试标题");
        Map<String,String> map=new HashMap<>();map.put("aaa","Bbb");
        uniappPushMsgRequest.setPayload(map.toString());
        uniappPushMsgRequest.setForce_notification(true);
        uniappPushMsgRequest.setPush_clientid("747b4e9677696099e8af49b96fae7ea5");
        push(uniappPushMsgRequest);*/
    }


}
