package com.bxm.lovelink.common.integration.wechat;

import lombok.Data;
import lombok.EqualsAndHashCode;
import org.apache.commons.lang3.StringUtils;

import java.util.Objects;

/**
 * @author zhangdong
 * @date 2025/5/15
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class AccessTokenResponse extends CommonResponse {

    private String access_token;
    private Integer expires_in;
    private String refresh_token;
    private String openid;
    private String scope;
    private String unionid;

    public boolean isSuccess() {
        return Objects.isNull(errcode) && StringUtils.isNotBlank(openid) && StringUtils.isNotBlank(unionid);
    }


}
