package com.bxm.lovelink.common.integration.wechat;

import com.alibaba.fastjson.JSON;
import com.bxm.lovelink.common.exception.BusinessException;
import com.bxm.warcar.utils.HttpClientHelper;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.HttpStatus;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.springframework.context.annotation.Configuration;

import java.nio.charset.StandardCharsets;

/**
 * @author zhangdong
 * @date 2025/5/15
 */
@Configuration
@Slf4j
public class WechatAuthIntegration {

    private final HttpClient httpClient;

    private static final String ACCESS_TOKEN_URL = "https://api.weixin.qq.com/sns/oauth2/access_token";

    public WechatAuthIntegration() {
        httpClient = HttpClientHelper.createHttpClient(50, 50, 5000, 5000, 5000);
    }


    /**
     * app微信授权登录
     *
     * @param code
     * @return
     */
    public AccessTokenResponse auth(String code, String appId, String appSecret) {
        String param = "?appid=" + appId + "&secret=" + appSecret + "&code=" + code + "&grant_type=authorization_code";
        String errorMessage = "wechat auth error";
        try {
            HttpResponse response = httpClient.execute(new HttpGet(ACCESS_TOKEN_URL + param));
            String json = EntityUtils.toString(response.getEntity(), StandardCharsets.UTF_8);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != HttpStatus.SC_OK || StringUtils.isBlank(json)) {
                log.error(errorMessage + ",statusCode:{}, code:{}, response:{}", statusCode, code, json);
                throw new BusinessException(errorMessage);
            }
            AccessTokenResponse accessTokenResponse = JSON.parseObject(json, AccessTokenResponse.class);
            if (accessTokenResponse.isSuccess()) {
                return accessTokenResponse;
            }
            log.error(errorMessage + ",code:{}, response:{}", code, json);
            throw new BusinessException(errorMessage);
        } catch (BusinessException e) {
            throw e;
        } catch (Exception e) {
            log.error(errorMessage + ", code:{}", code, e);
            throw new BusinessException(errorMessage);
        }
    }

}
