package com.bxm.lovelink.common.interceptor;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.bxm.lovelink.common.utils.CmsUserUtils;
import org.apache.ibatis.reflection.MetaObject;
import org.springframework.context.annotation.Configuration;

import java.time.LocalDateTime;

/**
 * @author huxiao
 * @date 2024/3/15
 * @since 1.0.0
 */
@Configuration
public class OperationMetaObjectHandler implements MetaObjectHandler {

    @Override
    public void insertFill(MetaObject metaObject) {
        this.strictInsertFill(metaObject, "createUser", String.class, getLoginUserNameIgnoreException());
        this.strictInsertFill(metaObject, "createTime", LocalDateTime.class, LocalDateTime.now());
    }

    @Override
    public void updateFill(MetaObject metaObject) {
        this.strictUpdateFill(metaObject, "modifyUser", String.class, getLoginUserNameIgnoreException());
        this.strictUpdateFill(metaObject, "modifyTime", LocalDateTime.class, LocalDateTime.now());
    }

    private String getLoginUserNameIgnoreException() {
        try {
            return CmsUserUtils.getUserName();
        } catch (Exception e) {
            return null;
        }
    }
}
