package com.bxm.lovelink.common.listener.chat;

import com.bxm.lovelink.common.chat.ChatStat;
import com.bxm.lovelink.common.dal.entity.ChatSession;
import com.bxm.lovelink.common.dal.service.IChatSessionService;
import com.bxm.lovelink.common.event.chat.ChatCompletionEvent;
import com.bxm.warcar.integration.eventbus.EventListener;
import com.bxm.warcar.integration.eventbus.core.AllowConcurrentEvents;
import com.bxm.warcar.integration.eventbus.core.Subscribe;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

/**
 * @author Allen Hu
 * @date 2025/7/17
 */
@Component
public class ChatCompletionUpdateSessionListener implements EventListener<ChatCompletionEvent> {

    private final IChatSessionService chatSessionService;

    public ChatCompletionUpdateSessionListener(IChatSessionService chatSessionService) {
        this.chatSessionService = chatSessionService;
    }

    @Override
    @Subscribe
    @AllowConcurrentEvents
    public void consume(ChatCompletionEvent event) {
        ChatSession chatSession = event.getChatSession();
        ChatStat chatStat = event.getChatStat();
        if (null == chatStat) {
            return;
        }
        String cozeBotId = chatStat.getCozeBotId();
        String cozeConversationId = chatStat.getCozeConversationId();
        if (StringUtils.isNotBlank(cozeBotId)) {
            chatSession.setCozeBotId(cozeBotId);
        }
        if (StringUtils.isNotBlank(cozeConversationId)) {
            chatSession.setCozeConversationId(cozeConversationId);
        }
        chatSessionService.updateById(chatSession);
    }
}
