package com.bxm.lovelink.common.push;

import com.bxm.warcar.cache.KeyGenerator;
import com.bxm.warcar.utils.KeyBuilder;

import java.util.Objects;

/**
 * @author dll
 * @date 2025/7/25
 * @since 1.0
 */
public class TaskRedisKeys {

    /**
     * 推送目标指定范围的推送次数
     * @param range 推送目标范围，可以是场景名、也可以是任务ID
     * @param targetId 目标
     * @return Key
     */
    public static KeyGenerator stringPushCount(Object range, Long targetId) {
        return () -> KeyBuilder.build("lovelink", "push", "count", Objects.toString(range), targetId);
    }

    /**
     * 推送目标指定范围的推送次数
     * @param range 推送目标范围，可以是场景名、也可以是任务ID
     * @param targetId 目标
     * @return Key
     */
    public static KeyGenerator stringPushCount(Object range, String targetId) {
        return () -> KeyBuilder.build("lovelink", "push", "count", Objects.toString(range), targetId);
    }
}
