package com.bxm.lovelink.common.push.factory;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.render.PushRender;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;

import java.util.List;

/**
 * @author Allen Hu
 * @date 2025/6/18
 */
@Slf4j
public abstract class AbstractImmediatePushSceneService implements ImmediatePushSceneService, PushRender {

    private final IPushTaskService pushTaskService;

    protected AbstractImmediatePushSceneService(IPushTaskService pushTaskService) {
        this.pushTaskService = pushTaskService;
    }

    @Override
    public List<Push> create(PushTarget pushTarget) {
        // 首先查询这个场景的任务列表
        QueryWrapper<PushTask> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(PushTask.TASK_SCENE, this.of().name());
        queryWrapper.eq(PushTask.STATUS, 1);
        queryWrapper.orderByDesc(PushTask.CREATE_TIME);
        List<PushTask> pushTasks = pushTaskService.list(queryWrapper);
        if (CollectionUtils.isEmpty(pushTasks)) {
            log.info("场景[{}]没有需要处理任务", this.of().name());
            return null;
        }
        if (pushTasks.size() > 1) {
            log.warn("场景[{}]有多个任务，默认使用最新", this.of().name());
        }
        PushTask pushTask = pushTasks.get(0);
        return Lists.newArrayList(new Push(pushTask, pushTarget));
    }
}
