package com.bxm.lovelink.common.push.factory;

import com.alibaba.fastjson.JSON;

import java.util.HashMap;
import java.util.Map;

public enum PushScene {
    /**
     * 资料填写中断
     */
    DATA_INTERRUPT,
    /**
     * 头像上传失败提醒
     */
    HEAD_PICTURE_AUDIT_FAILE,
    /**
     * 首次注册后24H内初期未使用
     */
    REGISTER_SUCCESS_24H_NOT_USE,
    /**
     * 收到心动提醒
     */
    LOVE_REMIND,
    /**
     * 收到约见邀请
     */
    MEET_REQUEST,
    /**
     * 见面邀约被接受
     */
    ACCEPT_MEET_REQUEST,
    /**
     * 见面邀约被拒绝
     */
    REJECTED_MEET_REQUEST,
    /**
     * 约见邀请即将过期
     */
    EXPIRE_MEET_REQUEST,
    /**
     * 见面聊天有新消息 (红娘专属会话框)
     */
    NEW_NOTICE,
    /**
     * 理想伴侣信息未填写
     */
    NO_LOVE_CONDTION,
    /**
     * 用户流失召回
     */
    USER_RECALL_LOSS,
    /**
     * 双向心动
     */
    MUTUAL_LOVE,
    /**
     * 活动即将开始推送
     */
    ACTIVITY_START,

    /**
     * 解锁邀请卡片
     */
    UNLOCK_INVITE_CARD,
    /**
     * 完成基础信息引导
     */
    FINISH_BASIC_INFO_GUIDE,
    /**
     * 完成实名认证
     */
    FINISH_REAL_NAME,

    /**
     * 见面超时确认反馈
     */
    MEET_TIMEOUT_FEEDBACK
    ;



    public static void main(String[] args) {
        Map<String, String> map = new HashMap<>();
        map.put("DATA_INTERRUPT", "资料填写中断");
        map.put("HEAD_PICTURE_AUDIT_FAILE", "头像上传失败提醒");
        map.put("REGISTER_SUCCESS_24H_NOT_USE", "首次注册后24H内初期未使用");
        map.put("LOVE_REMIND", "收到心动提醒");
        map.put("ACCEPT_MEET_REQUEST","见面邀约被接受");
        map.put("MEET_REQUEST", "收到约见邀请");
        map.put("REJECTED_MEET_REQUEST", "见面邀约被拒绝");
        map.put("EXPIRE_MEET_REQUEST", "约见邀请即将过期");
        map.put("NEW_NOTICE", "见面聊天有新消息 (红娘专属会话框)");
        map.put("NO_LOVE_CONDTION", "理想伴侣信息未填写");
        map.put("USER_RECALL_LOSS", "用户流失召回");
        map.put("MUTUAL_LOVE", "双向心动");
        map.put("UNLOCK_INVITE_CARD", "解锁邀请卡片");
        map.put("FINISH_BASIC_INFO_GUIDE", "完成基础信息引导");
        map.put("FINISH_REAL_NAME", "完成实名认证");
        map.put("MEET_TIMEOUT_FEEDBACK","见面超时确认反馈");
        map.put("ACTIVITY_START","活动开始推送");
        System.out.println(JSON.toJSONString(map));

    }

}
