package com.bxm.lovelink.common.push.factory;

import com.bxm.warcar.integration.listeners.AbstractBeanBus;
import org.springframework.stereotype.Component;

@Component
public class PushSceneServiceFactory extends AbstractBeanBus<PushScene, PushSceneService> {

    @Override
    protected Class<PushSceneService> getInstanceClazz() {
        return PushSceneService.class;
    }

    @Override
    protected PushScene getKey(String beanName, PushSceneService bean) {
        return bean.of();
    }

    public TimerPushSceneService getTimerPushSceneService(PushScene pushScene) {
        PushSceneService pushSceneService = get(pushScene);
        return pushSceneService instanceof TimerPushSceneService ? (TimerPushSceneService) pushSceneService : null;
    }

    public ImmediatePushSceneService getImmediatePushSceneService(PushScene pushScene) {
        PushSceneService pushSceneService = get(pushScene);
        return pushSceneService instanceof ImmediatePushSceneService ? (ImmediatePushSceneService) pushSceneService : null;
    }
}
