package com.bxm.lovelink.common.push.factory;

import com.google.common.collect.Maps;
import lombok.Data;
import lombok.experimental.Accessors;

import java.time.LocalDateTime;
import java.util.Map;

/**
 * 接收推送消息的目标
 *
 * @author Allen Hu
 * @date 2025/6/17
 */
@Data
@Accessors(chain = true)
public class PushTarget {

    private Long userId;

    /**
     * 如果为null，表示不做中止逻辑处理
     */
    private LocalDateTime startTime;

    /**
     * 扩展数据
     */
    private Map<String, Object> extend = Maps.newHashMap();

    /**
     * payload
     */
    private Map<String, Object> payload;

    public PushTarget addExtend(String key, Object value) {
        this.extend.put(key, value);
        return this;
    }
}
