package com.bxm.lovelink.common.push.factory.impl;

import com.bxm.lovelink.common.dal.entity.PushTask;
import com.bxm.lovelink.common.dal.service.IPushTaskService;
import com.bxm.lovelink.common.push.factory.AbstractImmediatePushSceneService;
import com.bxm.lovelink.common.push.factory.PushScene;
import com.bxm.lovelink.common.push.factory.PushTarget;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 见面邀约被接受
 *
 * @author dll
 * @date 2025/6/17
 */
@Component
public class AcceptMeetRequestPushSceneService extends AbstractImmediatePushSceneService {

    public AcceptMeetRequestPushSceneService(IPushTaskService pushTaskService) {
        super(pushTaskService);
    }

    @Override
    public Map<String, Object> createTemplateParameters(PushTask pushTask, PushTarget pushTarget) {
        //“<nickName> 已接受了您的见面邀请！”
        String nickName = (String) pushTarget.getExtend().get("nickName");
        return new HashMap<String, Object>() {{
            put("nickName", nickName);
        }};
    }

    @Override
    public PushScene of() {
        return PushScene.NEW_NOTICE;
    }
}
